/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServerFilter;
import org.glassfish.grizzly.http.server.HttpServerProbe;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;

final class HttpServerProbeNotifier {
    HttpServerProbeNotifier() {
    }

    static void notifyRequestReceive(HttpServerFilter filter2, Connection connection, Request request) {
        HttpServerProbe[] probes = filter2.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpServerProbe probe : probes) {
                probe.onRequestReceiveEvent(filter2, connection, request);
            }
        }
    }

    static void notifyRequestComplete(HttpServerFilter filter2, Connection connection, Response response) {
        HttpServerProbe[] probes = filter2.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpServerProbe probe : probes) {
                probe.onRequestCompleteEvent(filter2, connection, response);
            }
        }
    }

    static void notifyRequestSuspend(HttpServerFilter filter2, Connection connection, Request request) {
        HttpServerProbe[] probes = filter2.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpServerProbe probe : probes) {
                probe.onRequestSuspendEvent(filter2, connection, request);
            }
        }
    }

    static void notifyRequestResume(HttpServerFilter filter2, Connection connection, Request request) {
        HttpServerProbe[] probes = filter2.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpServerProbe probe : probes) {
                probe.onRequestResumeEvent(filter2, connection, request);
            }
        }
    }

    static void notifyRequestTimeout(HttpServerFilter filter2, Connection connection, Request request) {
        HttpServerProbe[] probes = filter2.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpServerProbe probe : probes) {
                probe.onRequestTimeoutEvent(filter2, connection, request);
            }
        }
    }

    static void notifyRequestCancel(HttpServerFilter filter2, Connection connection, Request request) {
        HttpServerProbe[] probes = filter2.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpServerProbe probe : probes) {
                probe.onRequestCancelEvent(filter2, connection, request);
            }
        }
    }

    static void notifyBeforeService(HttpServerFilter filter2, Connection connection, Request request, HttpHandler httpHandler) {
        HttpServerProbe[] probes = filter2.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (HttpServerProbe probe : probes) {
                probe.onBeforeServiceEvent(filter2, connection, request, httpHandler);
            }
        }
    }
}

